/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar;

import com.almostreliable.summoningrituals.altar.AltarEntity;
import com.almostreliable.summoningrituals.util.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class AltarRenderer
implements BlockEntityRenderer<AltarEntity> {
    private static final int MAX_RENDER_DISTANCE = 32;
    private static final int MAX_ITEM_HEIGHT = 2;
    private static final int MAX_RESET = 60;
    private static final float MAX_PROGRESS_HEIGHT = 2.5f;
    private static final float HALF = 0.5f;
    private static final float ITEM_OFFSET = 1.5f;
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = this.mc.m_91291_();
    private float resetTimer;
    private double oldCircleOffset;

    public AltarRenderer(BlockEntityRendererProvider.Context ignoredContext) {
    }

    public void render(AltarEntity entity, float partial, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        if (this.mc.f_91074_ == null || entity.m_58904_() == null || entity.m_58899_().m_123331_((Vec3i)this.mc.f_91074_.m_142538_()) > Math.pow(32.0, 2.0)) {
            return;
        }
        stack.m_85836_();
        stack.m_85837_(0.5, (double)0.8f, 0.5);
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        int lightAbove = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_().m_7494_());
        Vec3 altarPos = MathUtils.shiftToCenter(MathUtils.vectorFromPos((Vec3i)entity.m_58899_()));
        Vec3 playerPos = this.mc.f_91074_.m_20182_();
        double playerAngle = Math.toDegrees(Math.atan2(altarPos.f_82479_ - playerPos.f_82479_, playerPos.f_82481_ - altarPos.f_82481_)) + 180.0;
        int progress = entity.getProgress();
        int processTime = entity.getProcessTime();
        stack.m_85837_(0.0, (double)(2.5f * MathUtils.modifier(progress, processTime, 0.0f)), 0.0);
        if (!entity.inventory.getCatalyst().m_41619_()) {
            stack.m_85836_();
            stack.m_85837_(0.0, (double)(1.0f - 0.75f * MathUtils.modifier(progress, processTime, 0.0f)), 0.0);
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            stack.m_85845_(Vector3f.f_122224_.m_122240_((float)playerAngle));
            this.itemRenderer.m_174269_(entity.inventory.getCatalyst(), ItemTransforms.TransformType.FIXED, lightAbove, overlay, stack, buffer, (int)entity.m_58899_().m_121878_());
            stack.m_85849_();
        }
        float axisRotation = MathUtils.singleRotation(entity.m_58904_().m_46467_());
        float scale = 1.0f - MathUtils.modifier(progress, processTime, 0.0f);
        if (progress == 0 && this.resetTimer > 0.0f) {
            scale = 1.0f - MathUtils.modifier(this.resetTimer, 60.0f, 0.0f);
            this.resetTimer = Math.max(0.0f, this.resetTimer - partial);
        }
        stack.m_85841_(scale, scale, scale);
        List<ItemStack> inputs = entity.inventory.getItems();
        for (int i = 0; i < inputs.size(); ++i) {
            stack.m_85836_();
            int itemRotation = MathUtils.flipCircle(Float.valueOf((float)i * 360.0f / (float)inputs.size()));
            double circleOffset = 0.0;
            if (progress > 0) {
                circleOffset = (double)(MathUtils.modifier(progress, processTime, 1.0f) * 360.0f * 3.0f) + this.oldCircleOffset;
            } else {
                this.oldCircleOffset = circleOffset = playerAngle;
            }
            float rotationDiff = MathUtils.singleRotation((double)(axisRotation + (float)itemRotation) - circleOffset);
            if (rotationDiff > 180.0f) {
                rotationDiff = 360.0f - rotationDiff;
            }
            float newHeight = rotationDiff / 180.0f * 2.0f;
            double playerOffset = Math.max(1.0 - altarPos.m_82554_(playerPos) / 8.0, 0.0);
            newHeight = (float)((double)newHeight * playerOffset);
            stack.m_85845_(Vector3f.f_122224_.m_122240_(MathUtils.singleRotation(Float.valueOf((float)itemRotation + axisRotation))));
            stack.m_85837_(0.0, (double)newHeight, -1.5);
            ItemStack item = inputs.get(i);
            if (!item.m_41619_()) {
                this.mc.m_91291_().m_174269_(item, ItemTransforms.TransformType.FIXED, lightAbove, overlay, stack, buffer, (int)entity.m_58899_().m_121878_());
            }
            stack.m_85849_();
        }
        if (processTime > 0 && progress >= processTime) {
            this.resetTimer = 60.0f;
        }
        stack.m_85849_();
    }
}

